import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample05_PharmacyStore1_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleLineSpace(3.0)
            .actionPrintImage(
              new StarXpandCommand.Printer.ImageParameter("logo_01.png", 300),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText(
              "I'm ${staff_name}, Thank you for allowing me to serve you today.\n",
            )
            .actionFeedLine(1)
            .actionPrintText("  270               10    9288   09136  027\n")
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText("RFN# ${rfn}\n")
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list.mark}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(2),
                )
                .actionPrintText(
                  "${item_list.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(27),
                )
                .actionPrintText(" ")
                .actionPrintText(
                  "${item_list.quantity}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    2,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText(
                  "${item_list.tax_mark}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(2),
                )
                .actionPrintText(
                  "${item_list.price%.2f}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    8,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                )
                .actionPrintText(
                  "${item_list.remarks}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(6),
                ),
            )
            .actionFeedLine(1)
            .actionPrintText("   A=0.25% SALES TAX")
            .actionPrintText(
              "${sales_tax%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                22,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("     TOTAL")
            .actionPrintText(
              "${total_price%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                32,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .actionPrintText(
              "${payment_method}",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                30,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Center,
                ),
              ),
            )
            .actionPrintText(
              "${payment_amount%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                12,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("     CASH BACK")
            .actionPrintText(
              "${cash_back%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                28,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .actionPrintText("  MAB ADVERTISED SAVINGS:")
            .actionPrintText(
              "${mab_serving%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                23,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("  MFG COUPON SAVINGS:")
            .actionPrintText(
              "${mfg_serving%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                27,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText(
              "-----\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                48,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("  YOUR TOTAL SAVINGS:")
            .actionPrintText(
              "${total_serving%.2f}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                27,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintBarcode(
              new StarXpandCommand.Printer.BarcodeParameter(
                "${barcode}",
                StarXpandCommand.Printer.BarcodeSymbology.Code128,
              ).setBarDots(1),
            )
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText("${address}\n" + "STORE\t${telephone_number}\n")
            .actionFeedLine(2)
            .actionPrintText("F=ELIGIBLE FLEX SPEND ACCT ITEM (FSA)\n")
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText(
              "THANK YOU\n" +
                "FOR FASTER SERVICE, CALL IN YOUR\n" +
                "PRESCRIPTION ORDER OR PLACE IT ON\n" +
                "${host_name} 24 HOURS IN ADVANCE\n",
            )
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText(
              "   ${date}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "${time}    \n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .actionPrintText(
              "*********************************************** \n" +
                "YOUR OPINION COUNTS!\n" +
                "*********************************************** \n",
            )
            .actionFeedLine(1)
            .actionPrintText("ENTER FOR A CHANCE TO WIN $10,000 CASH\n")
            .actionFeedLine(1)
            .actionPrintText(
              "PLEASE CALL TOLL FREE\n" +
                "${free_call}\n" +
                "CR LOGON TO\n" +
                "${host_name}\n",
            )
            .actionFeedLine(1)
            .actionPrintText(
              "WITHIN 72 HOURS TO COMPLETE A\n" +
                "SHORT SURVEY ABOUT YOUR RECENT\n" +
                "VISIT TO THIS STAR MICRONICS\n",
            )
            .actionFeedLine(1)
            .actionPrintText(
              "PARTICIPE PARA GANAR\n" + "$10,000 DOLARES IN EFECTIVO!\n",
            )
            .actionFeedLine(1)
            .actionPrintText(
              "FOR FAVOR LLAME AL NUMERO GRATUITO\n" +
                "${free_call} 0 VISITENOS EN\n" +
                "INTERNET EN:\n" +
                "${host_name}\n",
            )
            .actionFeedLine(1)
            .actionPrintText(
              "DURANTE LAS PROXIMAS 72 HOURS, PARA\n" +
                "LLENAR UNA EREVE ENCUESTA ACERCA DE\n" +
                "SU RECIENTE VISITA A ESTA\n" +
                "FARMACIA STAR MICRONICS.\n",
            )
            .actionFeedLine(1)
            .actionPrintText("SERVEY* ${survey_number}\n")
            .actionFeedLine(1)
            .actionPrintText(
              "SEE STORE FOR CONTEST RULES\n" +
                "VISITE LA TIENDA PARA DETALLES ACERCA\n" +
                "DE LOS REGLAS DEL CONCURSO.\n",
            )
            .actionFeedLine(1)
            .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
            .actionPrintText("STAR MICRONICS #${number}\n")
            .actionPrintText("SEQ # ${seq_number}\n")
            .actionPrintText("CARD# ${card_number}\n")
            .actionPrintText("SEQ # ${seq_number}  PAYMENT FROM PRIMARY\n")
            .actionFeedLine(2)
            .actionPrintText("RETAIN THIS RECEIPT FOR YOUR RECORDS\n")
            .actionFeedLine(2)
            .actionPrintText(
              "   ${date}",
              new StarXpandCommand.Printer.TextParameter().setWidth(24),
            )
            .actionPrintText(
              "${time}    \n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                24,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "staff_name" : "John Smith",
    "rfn" : "0913-8279-2597-0104-2420",
    "item_list" : [
        {
            "mark" : "",
            "name" : "BOX FAN 20\\"",
            "quantity" : 1,
            "tax_mark" : "A",
            "price" : 14.99,
            "remarks" : " SALE"
        },
        {
            "mark" : "F",
            "name" : "KICODAM 14S",
            "quantity" : 1,
            "tax_mark" : "A",
            "price" : 54.99,
            "remarks" : ""
        },
        {
            "mark" : "F",
            "name" : "  MFG COUPON",
            "quantity" : 1,
            "tax_mark" : "",
            "price" : 5.0,
            "remarks" : "-MFGC"
        },
        {
            "mark" : "",
            "name" : "   SUBTOTAL",
            "quantity" : null,
            "tax_mark" : "",
            "price" : 64.98,
            "remarks" : ""
        }
    ],
    "sales_tax" : 5.77,
    "total_price" : 70.75,
    "payment_method" : "CREDIT CARD",
    "payment_amount" : 70.75,
    "cash_back" : 0,
    "mab_serving" : 5.0,
    "mfg_serving" : 5.0,
    "total_serving" : 10.0,
    "barcode" : "0123456789012345678901234567890123456789",
    "address" : "123 Star Road, City,State 12345",
    "telephone_number" : "(000)123-4567",
    "host_name" : "STAR-M.JP",
    "date" : "APRIL 24, 2007",
    "time" : "12:38 PM",
    "free_call" : "0-123-456-7890",
    "survey_number" : "0913-6278-2697-0704-420-17",
    "number" : "9136",
    "seq_number" : "913627052",
    "card_number" : "****************1015"
}`,
    );
  }
}
